﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //Wir starten einen StreamReader (Instanz von TextReader)
            StreamReader r = null;

            try
            {
                //Da wir nicht sicher sind ob das vom User stimmt (willkürliche Eingabe in TextBox)
                //Müssen wir es zunächst "probieren"
                r = new StreamReader(textBox1.Text, Encoding.ASCII, true);
                string content = r.ReadToEnd();
                MessageBox.Show(content, "Anzeige", MessageBoxButtons.OK, MessageBoxIcon.Information);

                //können auch manuell Fehler auslösen
                //throw new Exception("Beispielfehler");
            }
            catch (IOException ex)
            {
                //Hier angekommen ist die Datei entweder blockiert oder existiert gar nicht
                MessageBox.Show(ex.Message, "Lesefehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            catch (Exception ex)
            {
                //Hier angekommen ist es entweder eine Out-Of-Memory Exception (sehr sehr große Datei)
                //oder etwas ganz unbekanntes
                MessageBox.Show(ex.Message, "Unbekannter Fehler", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            finally
            {
                //Was auch immer passiert ist - wir müssen den Reader schließen, falls dieser offen war
                if(r != null)
                    r.Close();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //Zunächst den Dialog aufmachen und falls dieser erfolgreich beendet wird abfragen
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string path = openFileDialog1.FileName;
                EigenerStream es = new EigenerStream(path);

                try
                {
                    //Wird er sowieso nie lesen können!
                    MessageBox.Show(es.ReadToEnd());
                }
                catch (Exception ex)
                {
                    //Wir fragen nur generell nach einer Exception ab - wir differenzieren hier nie
                    MessageBox.Show(ex.Message);
                }
            }
        }
    }
}
